<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class AiController extends Controller
{
    public function generateChatResponse(Request $request)
    {
        $request->validate([
            'prompt' => 'required|string',
            'history' => 'array',
        ]);

        $apiKey = env('GEMINI_API_KEY');
        if (!$apiKey) {
            return response()->json(['error' => 'AI Advisor is not available because the API key is not configured.'], 500);
        }

        $url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash-exp:generateContent?key={$apiKey}";

        $contents = [];
        if ($request->history) {
            foreach ($request->history as $msg) {
                $contents[] = [
                    'role' => $msg['role'],
                    'parts' => [['text' => $msg['parts'][0]['text']]]
                ];
            }
        }
        $contents[] = [
            'role' => 'user',
            'parts' => [['text' => $request->prompt]]
        ];

        $payload = [
            'contents' => $contents,
            'systemInstruction' => [
                'parts' => [['text' => 'You are a helpful AI assistant specializing in Indonesian tax regulations. Your name is "TaxAI". You must provide concise, clear, and accurate information based on the latest Indonesian tax laws (UU HPP, etc.). When presented with a calculation context, analyze it and answer user questions related to that context. Always include a disclaimer: "This information is for educational purposes only and should not be considered professional tax advice. Please consult with a certified tax consultant." Keep your answers helpful and easy to understand for someone who is not a tax expert. Do not invent regulations. If you don\'t know the answer, say so.']]
            ],
            'generationConfig' => [
                'temperature' => 0.5,
                'topP' => 0.9,
                'topK' => 40,
            ]
        ];

        try {
            $response = Http::withoutVerifying()->post($url, $payload);

            if ($response->successful()) {
                $data = $response->json();
                $text = $data['candidates'][0]['content']['parts'][0]['text'] ?? 'No response generated.';
                return response()->json(['response' => $text]);
            } else {
                return response()->json(['error' => 'Gemini API error: ' . $response->body()], 500);
            }
        } catch (\Exception $e) {
            return response()->json(['error' => 'Error processing request: ' . $e->getMessage()], 500);
        }
    }
}
